// PCMag_OLTP_Read_Select.cpp

#include "stdafx.h"
#include "PCMAG_ORA8.h"
#include "PCMag_OLTP_Read_Select.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_01,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_02,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_03,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_04,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_05,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_06,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_07,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_08,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_09,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_10,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_11,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_12,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_13,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_14,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_15,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_16,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_17,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_18,CXact,1)

// ================================================================================

// CXact_OLTP_Read_Select_01

CXact_OLTP_Read_Select_01::CXact_OLTP_Read_Select_01 (void)
{
	m_szName		= "OLTP Read Select 01";
	m_szDescription = "select p_key, p_code, p_date, p_signed, p_name from fourram where p_key = :randfourram";
	m_szSQL			= "select p_key, p_code, p_date, p_signed, p_name from fourram where p_key = :randfourram";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+01;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_01::~CXact_OLTP_Read_Select_01 (void)
{
}

BOOL CXact_OLTP_Read_Select_01::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_01::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_01::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind;
	unsigned long randfourram;
#define OLTP_READ_SELECT_01_NUM_COLS 5
	OCIDefine* pDefineArray[OLTP_READ_SELECT_01_NUM_COLS];
	struct OLTP_READ_SELECT_01 {
		int p_key;
		char p_code[11];
		char p_date[10];
		int p_signed;
		char p_name[21];
	};
	typedef struct OLTP_READ_SELECT_01 OLTP_READ_SELECT_01;
	struct OLTP_READ_SELECT_01_INDICATORS {
		sb2 p_key;
		sb2 p_code;
		sb2 p_date;
		sb2 p_signed;
		sb2 p_name;
	};
	typedef struct OLTP_READ_SELECT_01_INDICATORS OLTP_READ_SELECT_01_INDICATORS;
	OLTP_READ_SELECT_01 oltp_read_select_01_array[NUM_ROWS];
	OLTP_READ_SELECT_01_INDICATORS oltp_read_select_01_indicators_array[NUM_ROWS];

	// initialize variables
	pBind = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_01_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randfourram", -1, (dvoid *)&randfourram, (sword)sizeof(randfourram), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_01_array[0].p_key, (ub2)sizeof(oltp_read_select_01_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_select_01_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_select_01_array[0].p_code, (ub2)sizeof(oltp_read_select_01_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_select_01_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_select_01_array[0].p_date, (ub2)sizeof(oltp_read_select_01_array[0].p_date), SQLT_STR, (dvoid *)&oltp_read_select_01_indicators_array[0].p_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_01_array[0].p_signed, (ub2)sizeof(oltp_read_select_01_array[0].p_signed), SQLT_INT, (dvoid *)&oltp_read_select_01_indicators_array[0].p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_01_array[0].p_name, (ub2)sizeof(oltp_read_select_01_array[0].p_name), SQLT_STR, (dvoid *)&oltp_read_select_01_indicators_array[0].p_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_01_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_01_array[0]), (ub4)sizeof(oltp_read_select_01_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randfourram = (long) m_CRandom.GetRandom(2,20000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_01_array[iRowLoop].p_key << tab
					<< oltp_read_select_01_array[iRowLoop].p_code << tab
					<< oltp_read_select_01_array[iRowLoop].p_date << tab
					<< oltp_read_select_01_array[iRowLoop].p_signed << tab
					<< oltp_read_select_01_array[iRowLoop].p_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_01_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_select_01_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_select_01_array[iRowLoop%NUM_ROWS].p_date << tab
					<< oltp_read_select_01_array[iRowLoop%NUM_ROWS].p_signed << tab
					<< oltp_read_select_01_array[iRowLoop%NUM_ROWS].p_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_01_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_02

CXact_OLTP_Read_Select_02::CXact_OLTP_Read_Select_02 (void)
{
	m_szName		= "OLTP Read Select 02";
	m_szDescription = "select h_key, h_code, h_date, h_signed, h_address from hundred where h_key between :randbase and :randbaseplus order by h_address";
	m_szSQL			= "select h_key, h_code, h_date, h_signed, h_address from hundred where h_key between :randbase and :randbaseplus order by h_address";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+02;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_02::~CXact_OLTP_Read_Select_02 (void)
{
}

BOOL CXact_OLTP_Read_Select_02::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_02::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_02::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind1;
	OCIBind *pBind2;
	unsigned long randbase;
	unsigned long randbaseplus;
#define OLTP_READ_SELECT_02_NUM_COLS 5
	OCIDefine* pDefineArray[OLTP_READ_SELECT_02_NUM_COLS];
	struct OLTP_READ_SELECT_02 {
		int h_key;
		char h_code[11];
		char h_date[10];
		int h_signed;
		char h_address[81];
	};
	typedef struct OLTP_READ_SELECT_02 OLTP_READ_SELECT_02;
	struct OLTP_READ_SELECT_02_INDICATORS {
		sb2 h_key;
		sb2 h_code;
		sb2 h_date;
		sb2 h_signed;
		sb2 h_address;
	};
	typedef struct OLTP_READ_SELECT_02_INDICATORS OLTP_READ_SELECT_02_INDICATORS;
	OLTP_READ_SELECT_02 oltp_read_select_02_array[NUM_ROWS];
	OLTP_READ_SELECT_02_INDICATORS oltp_read_select_02_indicators_array[NUM_ROWS];

	// initialize variables
	pBind1 = (OCIBind *)NULL;
	pBind2 = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_02_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind1, pError, (text *) ":randbase", -1, (dvoid *)&randbase, (sword)sizeof(randbase), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIBindByName (pStmt, &pBind2, pError, (text *) ":randbaseplus", -1, (dvoid *)&randbaseplus, (sword)sizeof(randbaseplus), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_02_array[0].h_key, (ub2)sizeof(oltp_read_select_02_array[0].h_key), SQLT_INT, (dvoid *)&oltp_read_select_02_indicators_array[0].h_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_select_02_array[0].h_code, (ub2)sizeof(oltp_read_select_02_array[0].h_code), SQLT_STR, (dvoid *)&oltp_read_select_02_indicators_array[0].h_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_select_02_array[0].h_date, (ub2)sizeof(oltp_read_select_02_array[0].h_date), SQLT_STR, (dvoid *)&oltp_read_select_02_indicators_array[0].h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_02_array[0].h_signed, (ub2)sizeof(oltp_read_select_02_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_select_02_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_02_array[0].h_address, (ub2)sizeof(oltp_read_select_02_array[0].h_address), SQLT_STR, (dvoid *)&oltp_read_select_02_indicators_array[0].h_address, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_02_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_02_array[0]), (ub4)sizeof(oltp_read_select_02_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);
	randbaseplus = randbase + 200;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_02_array[iRowLoop].h_key << tab
					<< oltp_read_select_02_array[iRowLoop].h_code << tab
					<< oltp_read_select_02_array[iRowLoop].h_date << tab
					<< oltp_read_select_02_array[iRowLoop].h_signed << tab
					<< oltp_read_select_02_array[iRowLoop].h_address << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_02_array[iRowLoop%NUM_ROWS].h_key << tab
					<< oltp_read_select_02_array[iRowLoop%NUM_ROWS].h_code << tab
					<< oltp_read_select_02_array[iRowLoop%NUM_ROWS].h_date << tab
					<< oltp_read_select_02_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_select_02_array[iRowLoop%NUM_ROWS].h_address << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_02_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_03

CXact_OLTP_Read_Select_03::CXact_OLTP_Read_Select_03 (void)
{
	m_szName		= "OLTP Read Select 03";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_key = 1001";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+03;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_03::~CXact_OLTP_Read_Select_03 (void)
{
}

BOOL CXact_OLTP_Read_Select_03::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_03::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_03::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_03_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_03_NUM_COLS];
	struct OLTP_READ_SELECT_03 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_03 OLTP_READ_SELECT_03;
	struct OLTP_READ_SELECT_03_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_03_INDICATORS OLTP_READ_SELECT_03_INDICATORS;
	OLTP_READ_SELECT_03 oltp_read_select_03_array[NUM_ROWS];
	OLTP_READ_SELECT_03_INDICATORS oltp_read_select_03_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_03_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_03_array[0].t_key, (ub2)sizeof(oltp_read_select_03_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_03_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_03_array[0].t_int, (ub2)sizeof(oltp_read_select_03_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_03_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_03_array[0].t_signed, (ub2)sizeof(oltp_read_select_03_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_03_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_03_array[0].t_double, (ub2)sizeof(oltp_read_select_03_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_03_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_03_array[0].t_code, (ub2)sizeof(oltp_read_select_03_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_03_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_03_array[0].t_name, (ub2)sizeof(oltp_read_select_03_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_03_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_03_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_03_array[0]), (ub4)sizeof(oltp_read_select_03_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_03_array[iRowLoop].t_key << tab
					<< oltp_read_select_03_array[iRowLoop].t_int << tab
					<< oltp_read_select_03_array[iRowLoop].t_signed << tab
					<< oltp_read_select_03_array[iRowLoop].t_double << tab
					<< oltp_read_select_03_array[iRowLoop].t_code << tab
					<< oltp_read_select_03_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_03_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_03_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_03_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_03_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_03_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_03_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_03_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_04

CXact_OLTP_Read_Select_04::CXact_OLTP_Read_Select_04 (void)
{
	m_szName		= "OLTP Read Select 04";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_code = 'BENCHMARKS'";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+04;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_04::~CXact_OLTP_Read_Select_04 (void)
{
}

BOOL CXact_OLTP_Read_Select_04::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_04::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_04::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_04_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_04_NUM_COLS];
	struct OLTP_READ_SELECT_04 {
		int p_key;
		int p_int;
		int p_signed;
		double p_double;
		char p_code[11];
		char p_name[21];
	};
	typedef struct OLTP_READ_SELECT_04 OLTP_READ_SELECT_04;
	struct OLTP_READ_SELECT_04_INDICATORS {
		sb2 p_key;
		sb2 p_int;
		sb2 p_signed;
		sb2 p_double;
		sb2 p_code;
		sb2 p_name;
	};
	typedef struct OLTP_READ_SELECT_04_INDICATORS OLTP_READ_SELECT_04_INDICATORS;
	OLTP_READ_SELECT_04 oltp_read_select_04_array[NUM_ROWS];
	OLTP_READ_SELECT_04_INDICATORS oltp_read_select_04_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_04_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;

	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_04_array[0].p_key, (ub2)sizeof(oltp_read_select_04_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_select_04_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_04_array[0].p_int, (ub2)sizeof(oltp_read_select_04_array[0].p_int), SQLT_INT, (dvoid *)&oltp_read_select_04_indicators_array[0].p_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_04_array[0].p_signed, (ub2)sizeof(oltp_read_select_04_array[0].p_signed), SQLT_INT, (dvoid *)&oltp_read_select_04_indicators_array[0].p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_04_array[0].p_double, (ub2)sizeof(oltp_read_select_04_array[0].p_double), SQLT_FLT, (dvoid *)&oltp_read_select_04_indicators_array[0].p_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_04_array[0].p_code, (ub2)sizeof(oltp_read_select_04_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_select_04_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_04_array[0].p_name, (ub2)sizeof(oltp_read_select_04_array[0].p_name), SQLT_STR, (dvoid *)&oltp_read_select_04_indicators_array[0].p_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_04_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_04_array[0]), (ub4)sizeof(oltp_read_select_04_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_04_array[iRowLoop].p_key << tab
					<< oltp_read_select_04_array[iRowLoop].p_int << tab
					<< oltp_read_select_04_array[iRowLoop].p_signed << tab
					<< oltp_read_select_04_array[iRowLoop].p_double << tab
					<< oltp_read_select_04_array[iRowLoop].p_code << tab
					<< oltp_read_select_04_array[iRowLoop].p_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_04_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_select_04_array[iRowLoop%NUM_ROWS].p_int << tab
					<< oltp_read_select_04_array[iRowLoop%NUM_ROWS].p_signed << tab
					<< oltp_read_select_04_array[iRowLoop%NUM_ROWS].p_double << tab
					<< oltp_read_select_04_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_select_04_array[iRowLoop%NUM_ROWS].p_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_04_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_05

CXact_OLTP_Read_Select_05::CXact_OLTP_Read_Select_05 (void)
{
	m_szName		= "OLTP Read Select 05";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_key <= 100";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_key <= 100";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+05;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_05::~CXact_OLTP_Read_Select_05 (void)
{
}

BOOL CXact_OLTP_Read_Select_05::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_05::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_05::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_05_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_05_NUM_COLS];
	struct OLTP_READ_SELECT_05 {
		int p_key;
		int p_int;
		int p_signed;
		double p_double;
		char p_code[11];
		char p_name[21];
	};
	typedef struct OLTP_READ_SELECT_05 OLTP_READ_SELECT_05;
	struct OLTP_READ_SELECT_05_INDICATORS {
		sb2 p_key;
		sb2 p_int;
		sb2 p_signed;
		sb2 p_double;
		sb2 p_code;
		sb2 p_name;
	};
	typedef struct OLTP_READ_SELECT_05_INDICATORS OLTP_READ_SELECT_05_INDICATORS;
	OLTP_READ_SELECT_05 oltp_read_select_05_array[NUM_ROWS];
	OLTP_READ_SELECT_05_INDICATORS oltp_read_select_05_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_05_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_05_array[0].p_key, (ub2)sizeof(oltp_read_select_05_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_select_05_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_05_array[0].p_int, (ub2)sizeof(oltp_read_select_05_array[0].p_int), SQLT_INT, (dvoid *)&oltp_read_select_05_indicators_array[0].p_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_05_array[0].p_signed, (ub2)sizeof(oltp_read_select_05_array[0].p_signed), SQLT_INT, (dvoid *)&oltp_read_select_05_indicators_array[0].p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_05_array[0].p_double, (ub2)sizeof(oltp_read_select_05_array[0].p_double), SQLT_FLT, (dvoid *)&oltp_read_select_05_indicators_array[0].p_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_05_array[0].p_code, (ub2)sizeof(oltp_read_select_05_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_select_05_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_05_array[0].p_name, (ub2)sizeof(oltp_read_select_05_array[0].p_name), SQLT_STR, (dvoid *)&oltp_read_select_05_indicators_array[0].p_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_05_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_05_array[0]), (ub4)sizeof(oltp_read_select_05_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_05_array[iRowLoop].p_key << tab
					<< oltp_read_select_05_array[iRowLoop].p_int << tab
					<< oltp_read_select_05_array[iRowLoop].p_signed << tab
					<< oltp_read_select_05_array[iRowLoop].p_double << tab
					<< oltp_read_select_05_array[iRowLoop].p_code << tab
					<< oltp_read_select_05_array[iRowLoop].p_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_05_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_select_05_array[iRowLoop%NUM_ROWS].p_int << tab
					<< oltp_read_select_05_array[iRowLoop%NUM_ROWS].p_signed << tab
					<< oltp_read_select_05_array[iRowLoop%NUM_ROWS].p_double << tab
					<< oltp_read_select_05_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_select_05_array[iRowLoop%NUM_ROWS].p_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_05_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_06

CXact_OLTP_Read_Select_06::CXact_OLTP_Read_Select_06 (void)
{
	m_szName		= "OLTP Read Select 06";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_int = :randbase";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_int = :randbase";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+06;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_06::~CXact_OLTP_Read_Select_06 (void)
{
}

BOOL CXact_OLTP_Read_Select_06::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_06::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_06::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind;
	unsigned long randbase;
#define OLTP_READ_SELECT_06_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_06_NUM_COLS];
	struct OLTP_READ_SELECT_06 {
		int p_key;
		int p_int;
		int p_signed;
		double p_double;
		char p_code[11];
		char p_name[21];
	};
	typedef struct OLTP_READ_SELECT_06 OLTP_READ_SELECT_06;
	struct OLTP_READ_SELECT_06_INDICATORS {
		sb2 p_key;
		sb2 p_int;
		sb2 p_signed;
		sb2 p_double;
		sb2 p_code;
		sb2 p_name;
	};
	typedef struct OLTP_READ_SELECT_06_INDICATORS OLTP_READ_SELECT_06_INDICATORS;
	OLTP_READ_SELECT_06 oltp_read_select_06_array[NUM_ROWS];
	OLTP_READ_SELECT_06_INDICATORS oltp_read_select_06_indicators_array[NUM_ROWS];

	// initialize variables
	pBind = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_06_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randbase", -1, (dvoid *)&randbase, (sword)sizeof(randbase), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_06_array[0].p_key, (ub2)sizeof(oltp_read_select_06_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_select_06_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_06_array[0].p_int, (ub2)sizeof(oltp_read_select_06_array[0].p_int), SQLT_INT, (dvoid *)&oltp_read_select_06_indicators_array[0].p_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_06_array[0].p_signed, (ub2)sizeof(oltp_read_select_06_array[0].p_signed), SQLT_INT, (dvoid *)&oltp_read_select_06_indicators_array[0].p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_06_array[0].p_double, (ub2)sizeof(oltp_read_select_06_array[0].p_double), SQLT_FLT, (dvoid *)&oltp_read_select_06_indicators_array[0].p_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_06_array[0].p_code, (ub2)sizeof(oltp_read_select_06_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_select_06_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_06_array[0].p_name, (ub2)sizeof(oltp_read_select_06_array[0].p_name), SQLT_STR, (dvoid *)&oltp_read_select_06_indicators_array[0].p_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_06_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_06_array[0]), (ub4)sizeof(oltp_read_select_06_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_06_array[iRowLoop].p_key << tab
					<< oltp_read_select_06_array[iRowLoop].p_int << tab
					<< oltp_read_select_06_array[iRowLoop].p_signed << tab
					<< oltp_read_select_06_array[iRowLoop].p_double << tab
					<< oltp_read_select_06_array[iRowLoop].p_code << tab
					<< oltp_read_select_06_array[iRowLoop].p_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_06_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_select_06_array[iRowLoop%NUM_ROWS].p_int << tab
					<< oltp_read_select_06_array[iRowLoop%NUM_ROWS].p_signed << tab
					<< oltp_read_select_06_array[iRowLoop%NUM_ROWS].p_double << tab
					<< oltp_read_select_06_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_select_06_array[iRowLoop%NUM_ROWS].p_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_06_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_07

CXact_OLTP_Read_Select_07::CXact_OLTP_Read_Select_07 (void)
{
	m_szName		= "OLTP Read Select 07";
	m_szDescription = "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_key <= 1000";
	m_szSQL			= "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_key <= 1000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+07;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_07::~CXact_OLTP_Read_Select_07 (void)
{
}

BOOL CXact_OLTP_Read_Select_07::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_07::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_07::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_07_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_07_NUM_COLS];
	struct OLTP_READ_SELECT_07 {
		int u_key;
		int u_int;
		int u_signed;
		double u_double;
		char u_code[11];
		char u_name[21];
	};
	typedef struct OLTP_READ_SELECT_07 OLTP_READ_SELECT_07;
	struct OLTP_READ_SELECT_07_INDICATORS {
		sb2 u_key;
		sb2 u_int;
		sb2 u_signed;
		sb2 u_double;
		sb2 u_code;
		sb2 u_name;
	};
	typedef struct OLTP_READ_SELECT_07_INDICATORS OLTP_READ_SELECT_07_INDICATORS;
	OLTP_READ_SELECT_07 oltp_read_select_07_array[NUM_ROWS];
	OLTP_READ_SELECT_07_INDICATORS oltp_read_select_07_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_07_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_07_array[0].u_key, (ub2)sizeof(oltp_read_select_07_array[0].u_key), SQLT_INT, (dvoid *)&oltp_read_select_07_indicators_array[0].u_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_07_array[0].u_int, (ub2)sizeof(oltp_read_select_07_array[0].u_int), SQLT_INT, (dvoid *)&oltp_read_select_07_indicators_array[0].u_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_07_array[0].u_signed, (ub2)sizeof(oltp_read_select_07_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_select_07_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_07_array[0].u_double, (ub2)sizeof(oltp_read_select_07_array[0].u_double), SQLT_FLT, (dvoid *)&oltp_read_select_07_indicators_array[0].u_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_07_array[0].u_code, (ub2)sizeof(oltp_read_select_07_array[0].u_code), SQLT_STR, (dvoid *)&oltp_read_select_07_indicators_array[0].u_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_07_array[0].u_name, (ub2)sizeof(oltp_read_select_07_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_select_07_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_07_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_07_array[0]), (ub4)sizeof(oltp_read_select_07_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_07_array[iRowLoop].u_key << tab
					<< oltp_read_select_07_array[iRowLoop].u_int << tab
					<< oltp_read_select_07_array[iRowLoop].u_signed << tab
					<< oltp_read_select_07_array[iRowLoop].u_double << tab
					<< oltp_read_select_07_array[iRowLoop].u_code << tab
					<< oltp_read_select_07_array[iRowLoop].u_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_07_array[iRowLoop%NUM_ROWS].u_key << tab
					<< oltp_read_select_07_array[iRowLoop%NUM_ROWS].u_int << tab
					<< oltp_read_select_07_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_select_07_array[iRowLoop%NUM_ROWS].u_double << tab
					<< oltp_read_select_07_array[iRowLoop%NUM_ROWS].u_code << tab
					<< oltp_read_select_07_array[iRowLoop%NUM_ROWS].u_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_07_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_08

CXact_OLTP_Read_Select_08::CXact_OLTP_Read_Select_08 (void)
{
	m_szName		= "OLTP Read Select 08";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and (t_key between :randbillion and :randbillionplus)";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and (t_key between :randbillion and :randbillionplus)";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+8;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_08::~CXact_OLTP_Read_Select_08 (void)
{
}

BOOL CXact_OLTP_Read_Select_08::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_08::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_08::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind1;
	OCIBind *pBind2;
	unsigned long randbillion;
	unsigned long randbillionplus;
#define OLTP_READ_SELECT_08_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_08_NUM_COLS];
	struct OLTP_READ_SELECT_08 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_08 OLTP_READ_SELECT_08;
	struct OLTP_READ_SELECT_08_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_08_INDICATORS OLTP_READ_SELECT_08_INDICATORS;
	OLTP_READ_SELECT_08 oltp_read_select_08_array[NUM_ROWS];
	OLTP_READ_SELECT_08_INDICATORS oltp_read_select_08_indicators_array[NUM_ROWS];

	// initialize variables
	pBind1 = (OCIBind *)NULL;
	pBind2 = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_08_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind1, pError, (text *) ":randbillion", -1, (dvoid *)&randbillion, (sword)sizeof(randbillion), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIBindByName (pStmt, &pBind2, pError, (text *) ":randbillionplus", -1, (dvoid *)&randbillionplus, (sword)sizeof(randbillionplus), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_08_array[0].t_key, (ub2)sizeof(oltp_read_select_08_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_08_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_08_array[0].t_int, (ub2)sizeof(oltp_read_select_08_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_08_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_08_array[0].t_signed, (ub2)sizeof(oltp_read_select_08_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_08_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_08_array[0].t_double, (ub2)sizeof(oltp_read_select_08_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_08_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_08_array[0].t_code, (ub2)sizeof(oltp_read_select_08_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_08_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_08_array[0].t_name, (ub2)sizeof(oltp_read_select_08_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_08_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_08_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_08_array[0]), (ub4)sizeof(oltp_read_select_08_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randbillion = (long) m_CRandom.GetRandom(2,1000000000);
	randbillionplus = randbillion + 10000;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_08_array[iRowLoop].t_key << tab
					<< oltp_read_select_08_array[iRowLoop].t_int << tab
					<< oltp_read_select_08_array[iRowLoop].t_signed << tab
					<< oltp_read_select_08_array[iRowLoop].t_double << tab
					<< oltp_read_select_08_array[iRowLoop].t_code << tab
					<< oltp_read_select_08_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_08_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_08_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_08_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_08_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_08_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_08_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_08_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_09

CXact_OLTP_Read_Select_09::CXact_OLTP_Read_Select_09 (void)
{
	m_szName		= "OLTP Read Select 09";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_signed <= -500000000";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_signed <= -500000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+9;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_09::~CXact_OLTP_Read_Select_09 (void)
{
}

BOOL CXact_OLTP_Read_Select_09::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_09::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_09::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_09_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_09_NUM_COLS];
	struct OLTP_READ_SELECT_09 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_09 OLTP_READ_SELECT_09;
	struct OLTP_READ_SELECT_09_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_09_INDICATORS OLTP_READ_SELECT_09_INDICATORS;
	OLTP_READ_SELECT_09 oltp_read_select_09_array[NUM_ROWS];
	OLTP_READ_SELECT_09_INDICATORS oltp_read_select_09_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_09_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_09_array[0].t_key, (ub2)sizeof(oltp_read_select_09_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_09_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_09_array[0].t_int, (ub2)sizeof(oltp_read_select_09_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_09_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_09_array[0].t_signed, (ub2)sizeof(oltp_read_select_09_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_09_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_09_array[0].t_double, (ub2)sizeof(oltp_read_select_09_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_09_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_09_array[0].t_code, (ub2)sizeof(oltp_read_select_09_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_09_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_09_array[0].t_name, (ub2)sizeof(oltp_read_select_09_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_09_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_09_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_09_array[0]), (ub4)sizeof(oltp_read_select_09_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_09_array[iRowLoop].t_key << tab
					<< oltp_read_select_09_array[iRowLoop].t_int << tab
					<< oltp_read_select_09_array[iRowLoop].t_signed << tab
					<< oltp_read_select_09_array[iRowLoop].t_double << tab
					<< oltp_read_select_09_array[iRowLoop].t_code << tab
					<< oltp_read_select_09_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_09_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_09_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_09_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_09_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_09_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_09_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_09_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_10

CXact_OLTP_Read_Select_10::CXact_OLTP_Read_Select_10 (void)
{
	m_szName		= "OLTP Read Select 10";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -475000000 order by t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -475000000 order by t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+10;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_10::~CXact_OLTP_Read_Select_10 (void)
{
}

BOOL CXact_OLTP_Read_Select_10::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_10::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_10::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_10_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_10_NUM_COLS];
	struct OLTP_READ_SELECT_10 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_10 OLTP_READ_SELECT_10;
	struct OLTP_READ_SELECT_10_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_10_INDICATORS OLTP_READ_SELECT_10_INDICATORS;
	OLTP_READ_SELECT_10 oltp_read_select_10_array[NUM_ROWS];
	OLTP_READ_SELECT_10_INDICATORS oltp_read_select_10_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_10_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_10_array[0].t_key, (ub2)sizeof(oltp_read_select_10_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_10_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_10_array[0].t_int, (ub2)sizeof(oltp_read_select_10_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_10_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_10_array[0].t_signed, (ub2)sizeof(oltp_read_select_10_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_10_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_10_array[0].t_double, (ub2)sizeof(oltp_read_select_10_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_10_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_10_array[0].t_code, (ub2)sizeof(oltp_read_select_10_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_10_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_10_array[0].t_name, (ub2)sizeof(oltp_read_select_10_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_10_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_10_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_10_array[0]), (ub4)sizeof(oltp_read_select_10_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_10_array[iRowLoop].t_key << tab
					<< oltp_read_select_10_array[iRowLoop].t_int << tab
					<< oltp_read_select_10_array[iRowLoop].t_signed << tab
					<< oltp_read_select_10_array[iRowLoop].t_double << tab
					<< oltp_read_select_10_array[iRowLoop].t_code << tab
					<< oltp_read_select_10_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_10_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_10_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_10_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_10_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_10_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_10_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_10_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_11

CXact_OLTP_Read_Select_11::CXact_OLTP_Read_Select_11 (void)
{
	m_szName		= "OLTP Read Select 11";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from twomill where p_key = 1";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from twomill where p_key = 1";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+11;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_11::~CXact_OLTP_Read_Select_11 (void)
{
}

BOOL CXact_OLTP_Read_Select_11::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_11::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_11::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_11_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_11_NUM_COLS];
	struct OLTP_READ_SELECT_11 {
		int p_key;
		int p_int;
		int p_signed;
		double p_double;
		char p_code[11];
		char p_name[21];
	};
	typedef struct OLTP_READ_SELECT_11 OLTP_READ_SELECT_11;
	struct OLTP_READ_SELECT_11_INDICATORS {
		sb2 p_key;
		sb2 p_int;
		sb2 p_signed;
		sb2 p_double;
		sb2 p_code;
		sb2 p_name;
	};
	typedef struct OLTP_READ_SELECT_11_INDICATORS OLTP_READ_SELECT_11_INDICATORS;
	OLTP_READ_SELECT_11 oltp_read_select_11_array[NUM_ROWS];
	OLTP_READ_SELECT_11_INDICATORS oltp_read_select_11_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_11_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_11_array[0].p_key, (ub2)sizeof(oltp_read_select_11_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_select_11_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_11_array[0].p_int, (ub2)sizeof(oltp_read_select_11_array[0].p_int), SQLT_INT, (dvoid *)&oltp_read_select_11_indicators_array[0].p_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_11_array[0].p_signed, (ub2)sizeof(oltp_read_select_11_array[0].p_signed), SQLT_INT, (dvoid *)&oltp_read_select_11_indicators_array[0].p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_11_array[0].p_double, (ub2)sizeof(oltp_read_select_11_array[0].p_double), SQLT_FLT, (dvoid *)&oltp_read_select_11_indicators_array[0].p_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_11_array[0].p_code, (ub2)sizeof(oltp_read_select_11_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_select_11_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_11_array[0].p_name, (ub2)sizeof(oltp_read_select_11_array[0].p_name), SQLT_STR, (dvoid *)&oltp_read_select_11_indicators_array[0].p_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_11_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_11_array[0]), (ub4)sizeof(oltp_read_select_11_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_11_array[iRowLoop].p_key << tab
					<< oltp_read_select_11_array[iRowLoop].p_int << tab
					<< oltp_read_select_11_array[iRowLoop].p_signed << tab
					<< oltp_read_select_11_array[iRowLoop].p_double << tab
					<< oltp_read_select_11_array[iRowLoop].p_code << tab
					<< oltp_read_select_11_array[iRowLoop].p_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_11_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_select_11_array[iRowLoop%NUM_ROWS].p_int << tab
					<< oltp_read_select_11_array[iRowLoop%NUM_ROWS].p_signed << tab
					<< oltp_read_select_11_array[iRowLoop%NUM_ROWS].p_double << tab
					<< oltp_read_select_11_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_select_11_array[iRowLoop%NUM_ROWS].p_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_11_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_12

CXact_OLTP_Read_Select_12::CXact_OLTP_Read_Select_12 (void)
{
	m_szName		= "OLTP Read Select 12";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name like 'THE+%' and t_signed > 499000000 order by t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name like 'THE+%' and t_signed > 499000000 order by t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+12;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_12::~CXact_OLTP_Read_Select_12 (void)
{
}

BOOL CXact_OLTP_Read_Select_12::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_12::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_12::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_12_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_12_NUM_COLS];
	struct OLTP_READ_SELECT_12 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_12 OLTP_READ_SELECT_12;
	struct OLTP_READ_SELECT_12_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_12_INDICATORS OLTP_READ_SELECT_12_INDICATORS;
	OLTP_READ_SELECT_12 oltp_read_select_12_array[NUM_ROWS];
	OLTP_READ_SELECT_12_INDICATORS oltp_read_select_12_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_12_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_12_array[0].t_key, (ub2)sizeof(oltp_read_select_12_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_12_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_12_array[0].t_int, (ub2)sizeof(oltp_read_select_12_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_12_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_12_array[0].t_signed, (ub2)sizeof(oltp_read_select_12_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_12_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_12_array[0].t_double, (ub2)sizeof(oltp_read_select_12_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_12_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_12_array[0].t_code, (ub2)sizeof(oltp_read_select_12_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_12_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_12_array[0].t_name, (ub2)sizeof(oltp_read_select_12_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_12_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_12_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_12_array[0]), (ub4)sizeof(oltp_read_select_12_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_12_array[iRowLoop].t_key << tab
					<< oltp_read_select_12_array[iRowLoop].t_int << tab
					<< oltp_read_select_12_array[iRowLoop].t_signed << tab
					<< oltp_read_select_12_array[iRowLoop].t_double << tab
					<< oltp_read_select_12_array[iRowLoop].t_code << tab
					<< oltp_read_select_12_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_12_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_12_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_12_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_12_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_12_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_12_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_12_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_13

CXact_OLTP_Read_Select_13::CXact_OLTP_Read_Select_13 (void)
{
	m_szName		= "OLTP Read Select 13";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date > TO_DATE('12/15/1999','MM/DD/YYYY') order by t_date";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date > TO_DATE('12/15/1999','MM/DD/YYYY') order by t_date";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+13;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_13::~CXact_OLTP_Read_Select_13 (void)
{
}

BOOL CXact_OLTP_Read_Select_13::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_13::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_13::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_13_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_13_NUM_COLS];
	struct OLTP_READ_SELECT_13 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_13 OLTP_READ_SELECT_13;
	struct OLTP_READ_SELECT_13_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_13_INDICATORS OLTP_READ_SELECT_13_INDICATORS;
	OLTP_READ_SELECT_13 oltp_read_select_13_array[NUM_ROWS];
	OLTP_READ_SELECT_13_INDICATORS oltp_read_select_13_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_13_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_13_array[0].t_key, (ub2)sizeof(oltp_read_select_13_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_13_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_13_array[0].t_int, (ub2)sizeof(oltp_read_select_13_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_13_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_13_array[0].t_signed, (ub2)sizeof(oltp_read_select_13_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_13_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_13_array[0].t_double, (ub2)sizeof(oltp_read_select_13_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_13_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_13_array[0].t_code, (ub2)sizeof(oltp_read_select_13_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_13_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_13_array[0].t_name, (ub2)sizeof(oltp_read_select_13_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_13_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_13_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_13_array[0]), (ub4)sizeof(oltp_read_select_13_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_13_array[iRowLoop].t_key << tab
					<< oltp_read_select_13_array[iRowLoop].t_int << tab
					<< oltp_read_select_13_array[iRowLoop].t_signed << tab
					<< oltp_read_select_13_array[iRowLoop].t_double << tab
					<< oltp_read_select_13_array[iRowLoop].t_code << tab
					<< oltp_read_select_13_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_13_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_13_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_13_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_13_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_13_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_13_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_13_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_14

CXact_OLTP_Read_Select_14::CXact_OLTP_Read_Select_14 (void)
{
	m_szName		= "OLTP Read Select 14";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date between TO_DATE('01/10/1942','MM-DD-YYYY') and TO_DATE('01/21/1942','MM/DD/YYYY') order by t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date between TO_DATE('01/10/1942','MM-DD-YYYY') and TO_DATE('01/21/1942','MM/DD/YYYY') order by t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+14;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_14::~CXact_OLTP_Read_Select_14 (void)
{
}

BOOL CXact_OLTP_Read_Select_14::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_14::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_14::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_14_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_14_NUM_COLS];
	struct OLTP_READ_SELECT_14 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_14 OLTP_READ_SELECT_14;
	struct OLTP_READ_SELECT_14_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_14_INDICATORS OLTP_READ_SELECT_14_INDICATORS;
	OLTP_READ_SELECT_14 oltp_read_select_14_array[NUM_ROWS];
	OLTP_READ_SELECT_14_INDICATORS oltp_read_select_14_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_14_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_14_array[0].t_key, (ub2)sizeof(oltp_read_select_14_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_14_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_14_array[0].t_int, (ub2)sizeof(oltp_read_select_14_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_14_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_14_array[0].t_signed, (ub2)sizeof(oltp_read_select_14_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_14_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_14_array[0].t_double, (ub2)sizeof(oltp_read_select_14_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_14_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_14_array[0].t_code, (ub2)sizeof(oltp_read_select_14_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_14_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_14_array[0].t_name, (ub2)sizeof(oltp_read_select_14_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_14_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_14_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_14_array[0]), (ub4)sizeof(oltp_read_select_14_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_14_array[iRowLoop].t_key << tab
					<< oltp_read_select_14_array[iRowLoop].t_int << tab
					<< oltp_read_select_14_array[iRowLoop].t_signed << tab
					<< oltp_read_select_14_array[iRowLoop].t_double << tab
					<< oltp_read_select_14_array[iRowLoop].t_code << tab
					<< oltp_read_select_14_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_14_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_14_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_14_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_14_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_14_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_14_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_14_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_15

CXact_OLTP_Read_Select_15::CXact_OLTP_Read_Select_15 (void)
{
	m_szName		= "OLTP Read Select 15";
	m_szDescription = "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_name = 'xxxxxxxxxx'";
	m_szSQL			= "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_name = 'xxxxxxxxxx'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+15;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_15::~CXact_OLTP_Read_Select_15 (void)
{
}

BOOL CXact_OLTP_Read_Select_15::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_15::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_15::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_15_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_15_NUM_COLS];
	struct OLTP_READ_SELECT_15 {
		int u_key;
		int u_int;
		int u_signed;
		double u_double;
		char u_code[11];
		char u_name[21];
	};
	typedef struct OLTP_READ_SELECT_15 OLTP_READ_SELECT_15;
	struct OLTP_READ_SELECT_15_INDICATORS {
		sb2 u_key;
		sb2 u_int;
		sb2 u_signed;
		sb2 u_double;
		sb2 u_code;
		sb2 u_name;
	};
	typedef struct OLTP_READ_SELECT_15_INDICATORS OLTP_READ_SELECT_15_INDICATORS;
	OLTP_READ_SELECT_15 oltp_read_select_15_array[NUM_ROWS];
	OLTP_READ_SELECT_15_INDICATORS oltp_read_select_15_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_15_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_15_array[0].u_key, (ub2)sizeof(oltp_read_select_15_array[0].u_key), SQLT_INT, (dvoid *)&oltp_read_select_15_indicators_array[0].u_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_15_array[0].u_int, (ub2)sizeof(oltp_read_select_15_array[0].u_int), SQLT_INT, (dvoid *)&oltp_read_select_15_indicators_array[0].u_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_15_array[0].u_signed, (ub2)sizeof(oltp_read_select_15_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_select_15_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_15_array[0].u_double, (ub2)sizeof(oltp_read_select_15_array[0].u_double), SQLT_FLT, (dvoid *)&oltp_read_select_15_indicators_array[0].u_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_15_array[0].u_code, (ub2)sizeof(oltp_read_select_15_array[0].u_code), SQLT_STR, (dvoid *)&oltp_read_select_15_indicators_array[0].u_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_15_array[0].u_name, (ub2)sizeof(oltp_read_select_15_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_select_15_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_15_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_15_array[0]), (ub4)sizeof(oltp_read_select_15_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_15_array[iRowLoop].u_key << tab
					<< oltp_read_select_15_array[iRowLoop].u_int << tab
					<< oltp_read_select_15_array[iRowLoop].u_signed << tab
					<< oltp_read_select_15_array[iRowLoop].u_double << tab
					<< oltp_read_select_15_array[iRowLoop].u_code << tab
					<< oltp_read_select_15_array[iRowLoop].u_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_15_array[iRowLoop%NUM_ROWS].u_key << tab
					<< oltp_read_select_15_array[iRowLoop%NUM_ROWS].u_int << tab
					<< oltp_read_select_15_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_select_15_array[iRowLoop%NUM_ROWS].u_double << tab
					<< oltp_read_select_15_array[iRowLoop%NUM_ROWS].u_code << tab
					<< oltp_read_select_15_array[iRowLoop%NUM_ROWS].u_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_15_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_16

CXact_OLTP_Read_Select_16::CXact_OLTP_Read_Select_16 (void)
{
	m_szName		= "OLTP Read Select 16";
	m_szDescription = "select distinct h_signed, h_address from hunthou where h_signed = 100 order by h_address";
	m_szSQL			= "select distinct h_signed, h_address from hunthou where h_signed = 100 order by h_address";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+16;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_16::~CXact_OLTP_Read_Select_16 (void)
{
}

BOOL CXact_OLTP_Read_Select_16::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_16::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_16::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_16_NUM_COLS 2
	OCIDefine* pDefineArray[OLTP_READ_SELECT_16_NUM_COLS];
	struct OLTP_READ_SELECT_16 {
		int h_signed;
		char h_address[81];
	};
	typedef struct OLTP_READ_SELECT_16 OLTP_READ_SELECT_16;
	struct OLTP_READ_SELECT_16_INDICATORS {
		sb2 h_signed;
		sb2 h_address;
	};
	typedef struct OLTP_READ_SELECT_16_INDICATORS OLTP_READ_SELECT_16_INDICATORS;
	OLTP_READ_SELECT_16 oltp_read_select_16_array[NUM_ROWS];
	OLTP_READ_SELECT_16_INDICATORS oltp_read_select_16_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_16_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_16_array[0].h_signed, (ub2)sizeof(oltp_read_select_16_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_select_16_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_select_16_array[0].h_address, (ub2)sizeof(oltp_read_select_16_array[0].h_address), SQLT_STR, (dvoid *)&oltp_read_select_16_indicators_array[0].h_address, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_16_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_16_array[0]), (ub4)sizeof(oltp_read_select_16_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_16_array[iRowLoop].h_signed << tab
					<< oltp_read_select_16_array[iRowLoop].h_address << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_16_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_select_16_array[iRowLoop%NUM_ROWS].h_address << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_16_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_17

CXact_OLTP_Read_Select_17::CXact_OLTP_Read_Select_17 (void)
{
	m_szName		= "OLTP Read Select 17";
	m_szDescription = "select distinct t_decim from tenthou order by t_decim";
	m_szSQL			= "select distinct t_decim from tenthou order by t_decim";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+17;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_17::~CXact_OLTP_Read_Select_17 (void)
{
}

BOOL CXact_OLTP_Read_Select_17::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_17::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_17::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_17_NUM_COLS 1
	OCIDefine* pDefineArray[OLTP_READ_SELECT_17_NUM_COLS];
	struct OLTP_READ_SELECT_17 {
		float t_decim;
	};
	typedef struct OLTP_READ_SELECT_17 OLTP_READ_SELECT_17;
	struct OLTP_READ_SELECT_17_INDICATORS {
		sb2 t_decim;
	};
	typedef struct OLTP_READ_SELECT_17_INDICATORS OLTP_READ_SELECT_17_INDICATORS;
	OLTP_READ_SELECT_17 oltp_read_select_17_array[NUM_ROWS];
	OLTP_READ_SELECT_17_INDICATORS oltp_read_select_17_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_17_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_17_array[0].t_decim, (ub2)sizeof(oltp_read_select_17_array[0].t_decim), SQLT_FLT, (dvoid *)&oltp_read_select_17_indicators_array[0].t_decim, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_17_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_17_array[0]), (ub4)sizeof(oltp_read_select_17_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_17_array[iRowLoop].t_decim << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_17_array[iRowLoop%NUM_ROWS].t_decim << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_17_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_18

CXact_OLTP_Read_Select_18::CXact_OLTP_Read_Select_18 (void)
{
	m_szName		= "OLTP Read Select 18";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -490000000 order by t_name, t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -490000000 order by t_name, t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+18;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_18::~CXact_OLTP_Read_Select_18 (void)
{
}

BOOL CXact_OLTP_Read_Select_18::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_18::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_18::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_SELECT_18_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_SELECT_18_NUM_COLS];
	struct OLTP_READ_SELECT_18 {
		int t_key;
		int t_int;
		int t_signed;
		double t_double;
		char t_code[11];
		char t_name[21];
	};
	typedef struct OLTP_READ_SELECT_18 OLTP_READ_SELECT_18;
	struct OLTP_READ_SELECT_18_INDICATORS {
		sb2 t_key;
		sb2 t_int;
		sb2 t_signed;
		sb2 t_double;
		sb2 t_code;
		sb2 t_name;
	};
	typedef struct OLTP_READ_SELECT_18_INDICATORS OLTP_READ_SELECT_18_INDICATORS;
	OLTP_READ_SELECT_18 oltp_read_select_18_array[NUM_ROWS];
	OLTP_READ_SELECT_18_INDICATORS oltp_read_select_18_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_18_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_select_18_array[0].t_key, (ub2)sizeof(oltp_read_select_18_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_select_18_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&oltp_read_select_18_array[0].t_int, (ub2)sizeof(oltp_read_select_18_array[0].t_int), SQLT_INT, (dvoid *)&oltp_read_select_18_indicators_array[0].t_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_select_18_array[0].t_signed, (ub2)sizeof(oltp_read_select_18_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_select_18_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_select_18_array[0].t_double, (ub2)sizeof(oltp_read_select_18_array[0].t_double), SQLT_FLT, (dvoid *)&oltp_read_select_18_indicators_array[0].t_double, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_select_18_array[0].t_code, (ub2)sizeof(oltp_read_select_18_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_select_18_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_select_18_array[0].t_name, (ub2)sizeof(oltp_read_select_18_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_select_18_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_SELECT_18_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_select_18_array[0]), (ub4)sizeof(oltp_read_select_18_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_18_array[iRowLoop].t_key << tab
					<< oltp_read_select_18_array[iRowLoop].t_int << tab
					<< oltp_read_select_18_array[iRowLoop].t_signed << tab
					<< oltp_read_select_18_array[iRowLoop].t_double << tab
					<< oltp_read_select_18_array[iRowLoop].t_code << tab
					<< oltp_read_select_18_array[iRowLoop].t_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_select_18_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_select_18_array[iRowLoop%NUM_ROWS].t_int << tab
					<< oltp_read_select_18_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_select_18_array[iRowLoop%NUM_ROWS].t_double << tab
					<< oltp_read_select_18_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_select_18_array[iRowLoop%NUM_ROWS].t_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_select_18_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}
